'************************************ INIT *************************************

Dim FSO					' Wird zum Kopieren bentigt

On Error Resume Next			' Lschen dieser Zeile bewirkt eine
					' Fehlermeldung bei leeren Verzeichnissen.

'Grundeinstellungen:

'Name der RAS-Verbindung; "" = keine Einwahl
Const RASDIAL_CONNECTION     = "RAS Verbindung"

'Benutzername fr RAS;    "" = Hamster-Einstellung benutzen
Const RASDIAL_USERNAME       = "Benutzer-Name"

'Passwort fr RAS;        "" = Hamster-Einstellungen benutzen
Const RASDIAL_PASSWORD       = "Passwort"

Const PURGE_BEFORE_TRANSFER  = False			'True  = "Purge" durchfhren
							'False = "Purge" nicht durchfhren

'Hamster-Konstanten initalisieren
Const HAM_PURGEOPT_DOALL     = &HF			'"Purge" bei Allem
Const HAM_PURGEOPT_DONEWS    = &H1			'"Purge" der News
Const HAM_PURGEOPT_DOHISTORY = &H2			'"Purge" der History
Const HAM_PURGEOPT_DOKILLS   = &H4			'"Purge" der Kills
Const HAM_WAITIDLE_INFINITE  = 0			'unbeschrnkte Wartezeit



'Hamster-Objekt initalisieren
'Hinweis: Wenn HAMSTER.EXE noch nicht luft, wird es geladen.
Set Hamster = Wscript.CreateObject( "Hamster.App" )

'Objekt fr Datei-Zugriffe initalisieren.
Set FSO = CreateObject("Scripting.FileSystemObject")


'*********************************** PURGE ************************************

'Whlen Sie eine Methode fr den "Purge", in dem Sie eines der folgenden vier
'Kommentar-Zeichen (') lschen.

If PURGE_BEFORE_TRANSFER Then
   Hamster.ControlWaitIdle HAM_WAITIDLE_INFINITE

'   Hamster.ControlRunPurge HAM_PURGEOPT_DOALL      
'   Hamster.ControlRunPurge HAM_PURGEOPT_DONEWS   
'   Hamster.ControlRunPurge HAM_PURGEOPT_DOHISTORY
'   Hamster.ControlRunPurge HAM_PURGEOPT_DOKILLS  

End If


'******************** BACKUP DER AUSGEHENDEN POST MACHEN **********************

'Sie mssen natrlich die Pfade an Ihre Gegebenheiten und Wnsche anpassen.

Hamster.ControlWaitIdle HAM_WAITIDLE_INFINITE
FSO.CopyFile "C:\Hamster\Mails\Mail.Out\*.*", "D:\Mail-Backup\Outgoing"


'********************************** EINWAHL ***********************************

'Der Computer wird bis zu 12mal versuchen, eine Modem- oder ISDN-Verbindung zu
'Ihrem Provider aufzubauen. Wenn alle Versuche fehlschlagen, wird das Script
'beendet.

Online = False
WieOft=0
DO UNTIL (Online = True) OR (WieOft >= 12)
  Online = Hamster.RasDial( RASDIAL_CONNECTION, RASDIAL_USERNAME, RASDIAL_PASSWORD )
   IF NOT Online Then
     WieOft = WieOft + 1
  End IF
LOOP

IF WieOft >=12 THEN
  WScript.Quit
End If


'***************************** ALLES EINSAMMELN ******************************

'POST
'====
'Diese Beispiel zeigt, wie man Post von drei Konten einsammeln und an zwei
'lokale Konten weiterverteilen kann. Natrlich mssen Provider, Kontonamen und
'Passwrter individuell eingetragen werden.

Hamster.ControlRunFetchMail "pop.aaa.net", "pop3", "Konto1", "Passwort1", "User1"
Hamster.ControlRunFetchMail "pop.bbb.net", "pop3", "Konto2", "Passwort2", "User1"
Hamster.ControlRunFetchMail "pop.ccc.net", "pop3", "Konto3", "Passwort3", "User2"

'NEWS
'====
'So werden Nachrichten aus allen Newsgroups und Servern gesendet und geholt, die
'im Hamster eingetragen sind.

'News senden
Hamster.ControlRunNewsPost ""

'News holen
Hamster.ControlRunNewsPull ""


Hamster.ControlWaitIdle HAM_WAITIDLE_INFINITE


'********************************* POST SENDEN **********************************

'Die folgenden Zeilen werden ausgehende Post an die oben genannten Konten senden.
'Auch hier mssen natrlich die Einstellungen angepasst werden.

Hamster.ControlRunSendMail "mail.aaa.net", "smtp", "User1@aaa.net"
Hamster.ControlRunSendMail "mail.bbb.net", "smtp", "User1@bbb.net"
Hamster.ControlRunSendMail "mail.ccc.net", "smtp", "User2@ccc.net"


'**************************** RAS-VERBINDUNG BEENDEN ****************************

Hamster.RasHangup


'*********************** BACKUP VON EINGEHENDER POST MACHEN **********************

'Auch hier mssen Sie die Pfad-Angaben anpassen.

FSO.CopyFile "C:\Hamster\Mails\User1\*.*", "D:\Mail-Backup\Incoming\User1"
FSO.CopyFile "C:\Hamster\Mails\User2\*.*", "D:\Mail-Backup\Incoming\User2"


'********************************** BEENDEN *************************************

'Hamster-Objekt wieder freigeben.
Wscript.DisconnectObject Hamster
